#include-once
#Include <file.au3>
#include <corz_essentials.au3>

Global $oMyRet[2]
Global $oMyError = ObjEvent("AutoIt.Error",	"MyErrFunc")

; Send mail with CDO.. Cooler.
; cor + corz.org 2008->tomorrow

Func _INetSmtpMailCom($s_SmtpServer, $s_FromName, $s_FromAddress, $s_ToAddress,	$s_Subject = "", $as_Body =	"",	$s_AttachFiles = "", _
			$s_CcAddress =	"",	$s_BccAddress =	"",	$s_Importance="Normal",	$s_Username	= "", $s_Password =	"",	$IPPort	= 25, $ssl = 0)

	Local $objEmail	= ObjCreate("CDO.Message")
	$objEmail.From = '"' & $s_FromName & '"	<' & $s_FromAddress	& '>'
	$objEmail.To = $s_ToAddress
	Local $i_Error = 0
	Local $i_Error_desciption =	""

	If $s_CcAddress	<> "" Then $objEmail.Cc	= $s_CcAddress
	If $s_BccAddress <>	"" Then	$objEmail.Bcc =	$s_BccAddress
	$objEmail.Subject =	$s_Subject

	If StringInStr($as_Body, "<") And StringInStr($as_Body,	">") Then
		$objEmail.HTMLBody = $as_Body
	Else
		$objEmail.Textbody = $as_Body &	@CRLF
	EndIf

	If $s_AttachFiles <> ""	Then
		Local $S_Files2Attach =	StringSplit($s_AttachFiles,	";")
		For	$x = 1 To $S_Files2Attach[0]
			$S_Files2Attach[$x]	= _PathFull($S_Files2Attach[$x])
; 			ConsoleWrite('@@ Debug : $S_Files2Attach[$x] = ' & $S_Files2Attach[$x] & @LF & '>Error code: ' & @error	& @LF) ;###	Debug Console
			If FileExists($S_Files2Attach[$x]) Then
				ConsoleWrite('File attachment added:	' &	$S_Files2Attach[$x]	& @LF)
				$objEmail.AddAttachment($S_Files2Attach[$x])
			Else
				ConsoleWrite('File attachment NOT added: ' & $S_Files2Attach[$x] & @LF)
				SetError(1)
				;Return 0
				exitloop
			EndIf
		Next
	EndIf

	$objEmail.Configuration.Fields.Item	("http://schemas.microsoft.com/cdo/configuration/sendusing") = 2	; 2 = cdoSendUsingPort
	$objEmail.Configuration.Fields.Item	("http://schemas.microsoft.com/cdo/configuration/smtpserver") =	$s_SmtpServer
	If Number($IPPort) = 0 then	$IPPort	= 25

	$objEmail.Configuration.Fields.Item	("http://schemas.microsoft.com/cdo/configuration/smtpserverport") =	$IPPort

	;Authenticated SMTP
	If $s_Username <> "" Then
		$objEmail.Configuration.Fields.Item	("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate")	= 1
		$objEmail.Configuration.Fields.Item	("http://schemas.microsoft.com/cdo/configuration/sendusername")	= $s_Username
		$objEmail.Configuration.Fields.Item	("http://schemas.microsoft.com/cdo/configuration/sendpassword")	= $s_Password
	EndIf

	If $ssl	== 1 Then
		$objEmail.Configuration.Fields.Item	("http://schemas.microsoft.com/cdo/configuration/smtpusessl") =	True
	EndIf

	;Update	settings
	$objEmail.Configuration.Fields.Update

	; Set Email	Importance & Priority..
	Switch $s_Importance
		Case "Highest"
			$objEmail.Fields.Item ("urn:schemas:mailheader:Importance")	= "Highest"
			$objEmail.Fields.Item ("urn:schemas:mailheader:Priority")	= "Highest"
			$objEmail.Fields.Item ("urn:schemas:mailheader:X-Priority")	= "1 (Highest)"
		Case "High"
			$objEmail.Fields.Item ("urn:schemas:mailheader:Importance")	= "High"
			$objEmail.Fields.Item ("urn:schemas:mailheader:Priority")	= "High"
			$objEmail.Fields.Item ("urn:schemas:mailheader:X-Priority")	= "2 (High)"
		Case "Normal"
			$objEmail.Fields.Item ("urn:schemas:mailheader:Importance")	= "Normal"
			$objEmail.Fields.Item ("urn:schemas:mailheader:Priority")	= "Normal"
			$objEmail.Fields.Item ("urn:schemas:mailheader:X-Priority")	= "3 (Normal)"
		Case "Low"
			$objEmail.Fields.Item ("urn:schemas:mailheader:Importance")	= "Low"
			$objEmail.Fields.Item ("urn:schemas:mailheader:Priority")	= "Low"
			$objEmail.Fields.Item ("urn:schemas:mailheader:X-Priority")	= "4 (Low)"
		Case "Lowest"
			$objEmail.Fields.Item ("urn:schemas:mailheader:Importance")	= "Lowest"
			$objEmail.Fields.Item ("urn:schemas:mailheader:Priority")	= "Lowest"
			$objEmail.Fields.Item ("urn:schemas:mailheader:X-Priority")	= "5 (Lowest)"
	EndSwitch

	; CorzSpaZio headers..
	$objEmail.Fields.Item ("urn:schemas:mailheader:X-Mailer")			= "CorzSpaZio"

	; update the fileds..
	$objEmail.Fields.Update

	; Sent the Message
	$objEmail.Send
	If @error Then
		SetError(2)
		Return $oMyRet[1]
	EndIf
	$objEmail=""

	ConsoleWrite("Sending Mail..." & @LF & @LF & "From:" & $s_FromName & @LF & "From:" & $s_FromAddress & @LF & "To:" & $s_ToAddress & @LF & "Subject:" & _
				$s_Subject & @LF & "Body:" & $as_Body & @LF & "Attached:" & $s_AttachFiles & @LF & "CC:" & $s_CcAddress & @LF & "BCC:" & $s_BccAddress & @LF & _
				"Priority:" & $s_Importance & @LF & "SMTP User:" & $s_Username & @LF & "SMTP Pass:" & $s_Password & @LF & "Port:" & $IPPort & @LF & _
				"SSL:" & ProcessWriteHumanCheckBoxValue($ssl) & @LF)
EndFunc


; Com Error	Handler
Func MyErrFunc()
	$HexNumber = Hex($oMyError.number, 8)
	$oMyRet[0] = $HexNumber
	$oMyRet[1] = StringStripWS($oMyError.description, 3)
	ConsoleWrite("### COM Error	!  Number: " & $HexNumber &	"	ScriptLine:	" &	$oMyError.scriptline & "   Description:" & $oMyRet[1] &	@LF)
	SetError(1); something to check	for	when this function returns
	Return
EndFunc	  ;==>MyErrFunc















; old-school direct TCP/IP method..
;


;#include <Date.au3>
;;===============================================================================
;;
;; Function Name:    _INetSmtpMail()
;; Description:      Sends an email using SMTP over TCP IP.
;; Parameter(s):     $s_SmtpServer	- SMTP server to be used for sending email
;;                   $s_FromName		- Name of sender
;;                   $s_FromAddress	- eMail address of sender
;;                   $s_ToAddress	- Address that email is to be sent to
;;                   $s_Subject		- Subject of eMail
;;					$as_Body		- Single dimension array containing the body of eMail as strings
;;					$s_helo			- Helo identifier (default @COMPUTERNAME) sometime needed by smtp server
;;					$s_first		- send before Helo identifier (default @CRLF) sometime needed by smtp server
;;					$b_trace		- trace on a splash window (default 0 = no trace)
;; Requirement(s):   None
;; Return Value(s):  On Success - Returns 1
;;                   On Failure - 0  and sets
;;											@ERROR = 1		-	Invalid Parameters
;;											@ERROR = 2		-	Unable to start TCP
;;											@ERROR = 3		-	Unable to resolve IP
;;											@ERROR = 4		-	Unable to create socket
;;											@ERROR = 5x		-	Cannot open SMTP session
;;											@ERROR = 50x	-	Cannot send body
;;											@ERROR = 5000	-	Cannot close SMTP session
;; Authors:        Original function to send email via TCP 	- Asimzameer
;;					Conversion to UDF						- Walkabout
;;					Correction	Helo, timeout, trace		- Jpm
;;					Correction send before Helo				- Jpm
;;					Fixed date								- (or
;;===============================================================================
;Func _INetSmtpMail($s_SmtpServer, $s_FromName, $s_FromAddress, $s_ToAddress, $s_Subject = "", _
;										$as_Body = "", $s_helo = "", $s_first=" ", $b_trace = 0)
;
;	Local $v_Socket
;	Local $s_IPAddress
;	Local $i_Count
;	Local $s_Send[6]
;	Local $s_ReplyCode[6];Return code from SMTP server indicating success
;
;	If $s_SmtpServer = "" Or $s_FromAddress = "" Or $s_ToAddress = "" Or $s_FromName = "" Or StringLen($s_FromName) > 256 Then
;		SetError(1)
;		Return 0
;	EndIf
;	If $s_helo = "" Then $s_helo = @ComputerName
;	If TCPStartup() = 0 Then
;		SetError(2)
;		Return 0
;	EndIf
;	StringRegExp($s_SmtpServer, "(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)")
;	If @extended Then
;		$s_IPAddress = $s_SmtpServer
;	Else
;		$s_IPAddress = TCPNameToIP($s_SmtpServer)
;	EndIf
;	If $s_IPAddress = "" Then
;		TCPShutdown()
;		SetError(3)
;		Return 0
;	EndIf
;	$v_Socket = TCPConnect($s_IPAddress, 25)
;	If $v_Socket = -1 Then
;		TCPShutdown()
;		SetError(4)
;		Return (0)
;	EndIf
;
;	$s_Send[0] = "HELO " & $s_helo & @CRLF
;	If StringLeft($s_helo,5) = "EHLO " Then $s_Send[0] = $s_helo & @CRLF
;	$s_ReplyCode[0] = "250"
;
;	$s_Send[1] = "MAIL FROM: <" & $s_FromAddress & ">" & @CRLF
;	$s_ReplyCode[1] = "250"
;	$s_Send[2] = "RCPT TO: <" & $s_ToAddress & ">" & @CRLF
;	$s_ReplyCode[2] = "250"
;	$s_Send[3] = "DATA" & @CRLF
;	$s_ReplyCode[3] = "354"
;
;	Local $aResult = _Date_Time_GetTimeZoneInformation()
;	Local $bias = -$aResult[1]/60
;	Local $biasH = Int($bias)
;	Local $biasM = 0
;	If $biasH <> $bias Then $biasM =  Abs($bias - $biasH) * 60
;	$bias =  StringFormat(" %+.2d%.2d", $biasH, $biasM) ; removed braces ;o)
;
;	$s_Send[4] = "From:" & $s_FromName & "<" & $s_FromAddress & ">" & @CRLF & _
;				"To:" & "<" & $s_ToAddress & ">" & @CRLF & _
;				"Subject:" & $s_Subject & @CRLF & _
;				"Mime-Version: 1.0" & @CRLF & _
;				"Date: " & _DateDayOfWeek(@WDAY, 1) & ", " & @MDAY & " " & _DateToMonth(@MON, 1) & " " & @YEAR & " " & @HOUR & ":" & @MIN & ":" & @SEC & $bias & @CRLF & _
;				"Content-Type: text/plain; charset=UTF-8" & @CRLF & _
;				@CRLF
;	$s_ReplyCode[4] = ""
;
;	$s_Send[5] = @CRLF & "." & @CRLF
;	$s_ReplyCode[5] = "250"
;
;	; open stmp session
;	If _SmtpSend($v_Socket, $s_Send[0], $s_ReplyCode[0], $b_trace, "220", $s_first) Then
;		SetError(50)
;		Return 0
;	EndIf
;	; send header
;	For $i_Count = 1 To UBound($s_Send) - 2
;		If _SmtpSend($v_Socket, $s_Send[$i_Count], $s_ReplyCode[$i_Count], $b_trace) Then
;			SetError(50 + $i_Count)
;			Return 0
;		EndIf
;	Next
;
;	; send body records (a record can be multiline : take care of a subline beginning with a dot should be ..)
;	For $i_Count = 0 To UBound($as_Body) - 1
;		; correct line beginning with a dot
;		If StringLeft($as_Body[$i_Count], 1) = "." Then $as_Body[$i_Count] = "." & $as_Body[$i_Count]
;
;		If _SmtpSend($v_Socket, $as_Body[$i_Count] & @CRLF, "", $b_trace) Then
;			SetError(500 + $i_Count)
;			Return 0
;		EndIf
;	Next
;
;	; close the smtp session
;	$i_Count = UBound($s_Send) - 1
;	If _SmtpSend($v_Socket, $s_Send[$i_Count], $s_ReplyCode[$i_Count], $b_trace) Then
;		SetError(5000)
;		Return 0
;	EndIf
;
;	TCPCloseSocket($v_Socket)
;	TCPShutdown()
;	Return 1
;EndFunc   ;==>_INetSmtpMail
;
;; internals routines----------------------------------
;Func _SmtpTrace($str, $timeout = 0)
;	Local $W_TITLE = "SMTP trace"
;	Local $g_smtptrace = ControlGetText($W_TITLE, "", "Static1")
;	$str = StringLeft(StringReplace($str, @CRLF, ""), 70)
;	$g_smtptrace &= @HOUR & ":" & @MIN & ":" & @SEC & " " & $str & @LF
;	If WinExists($W_TITLE) Then
;		ControlSetText($W_TITLE, "", "Static1", $g_smtptrace)
;	Else
;		SplashTextOn($W_TITLE, $g_smtptrace, 400, 500, 500, 100, 4 + 16, "", 8)
;	EndIf
;	If $timeout Then Sleep($timeout * 1000)
;EndFunc   ;==>_SmtpTrace
;
;Func _SmtpSend($v_Socket, $s_Send, $s_ReplyCode, $b_trace, $s_IntReply="", $s_first="")
;    Local $s_Receive, $i, $timer
;    If $b_trace Then _SmtpTrace($s_Send)
;
;    If $s_IntReply <> ""  Then
;
;        ; Send special first char to awake smtp server
;        If $s_first <> -1 Then
;            If TCPSend($v_Socket, $s_first) = 0 Then
;                TCPCloseSocket($v_Socket)
;                TCPShutdown()
;                Return 1; cannot send
;            EndIf
;        EndIf
;
;        ; Check intermediate reply before HELO acceptation
;        $s_Receive = ""
;        $timer = TimerInit()
;        While StringLeft($s_Receive,StringLen($s_IntReply)) <> $s_IntReply And TimerDiff($timer) < 45000
;            $s_Receive = TCPRecv($v_Socket, 1000)
;            If $b_trace And $s_Receive <> "" Then _SmtpTrace("intermediate->" & $s_Receive)
;        WEnd
;    EndIf
;
;    ; Send string.
;    If TCPSend($v_Socket, $s_Send) = 0 Then
;        TCPCloseSocket($v_Socket)
;        TCPShutdown()
;        Return 1; cannot send
;    EndIf
;
;    $timer = TimerInit()
;
;    $s_Receive = ""
;    While $s_Receive = "" And TimerDiff($timer) < 45000
;        $i += 1
;        $s_Receive = TCPRecv($v_Socket, 1000)
;        If $s_ReplyCode = "" Then ExitLoop
;    WEnd
;
;    If $s_ReplyCode <> "" Then
;        ; Check replycode
;        If $b_trace Then _SmtpTrace($i & " <- " & $s_Receive)
;
;        If StringLeft($s_Receive, StringLen($s_ReplyCode)) <> $s_ReplyCode Then
;            TCPCloseSocket($v_Socket)
;            TCPShutdown()
;            If $b_trace Then _SmtpTrace("<-> " & $s_ReplyCode, 5)
;            Return 2; bad receive code
;        EndIf
;    EndIf
;
;    Return 0
;EndFunc   ;==>_SmtpSend

